import { IParam, MainControlState } from '@core';

/**
 * @description 选择视图面板通讯对象
 * @export
 * @interface TabViewPanelControlState
 * @extends {MainControlState}
 */
export interface TabViewPanelControlState extends MainControlState {

  /**
   * 导航过滤项
   *
   * @type {string}
   * @memberof TabViewPanelControlState
   */
  navFilter?:string;

  /**
   * 导航关系
   *
   * @type {IParam}
   * @memberof TabViewPanelControlState
   */
  navPSDer?: IParam;

  /**
   * 导航上下文集合
   *
   * @type {IParam}
   * @memberof TabViewPanelControlState
   */
  navContexts?:IParam;

  /**
   * 导航参数集合
   *
   * @type {IParam}
   * @memberof TabViewPanelControlState
   */
  navParams?:IParam;

  /**
   * 父视图，即分页导航视图
   *
   * @type {*}
   * @memberof TabViewPanelControlState
   */
  parentView: any;
}